'use strict';
const MANIFEST = 'flutter-app-manifest';
const TEMP = 'flutter-temp-cache';
const CACHE_NAME = 'flutter-app-cache';

const RESOURCES = {"assets/AssetManifest.bin": "bb2f44cf5e3338cb91fff50bb73d7baf",
"assets/AssetManifest.bin.json": "e36fa91027ee99909f381711d5dbac67",
"assets/AssetManifest.json": "32cd98274b230395a9a4a67b84a8aa01",
"assets/assets/footer2.jpg": "37aa27051b0fc493850ea54cceae3457",
"assets/assets/foter1.jpg": "6eb436e0c785575054e3943201095d4f",
"assets/assets/fst.jpg": "496b6efd40a227ea4d5b8c0230b6a555",
"assets/assets/getdown.png": "cb8e7ff9178feb5dd63b5743d29cf20f",
"assets/assets/hm.png": "64cf28e1e707b3a3793d1d3ab2102a47",
"assets/assets/hmgok.jpg": "c3c5f33ddccef48e72c0a9e6ef24138c",
"assets/assets/loader.gif": "750fc7f7c6391b7ec37212f9ae002875",
"assets/assets/logo.png": "b7054f4241a6244e3bb11b88c5203ddd",
"assets/assets/logokm.png": "b7054f4241a6244e3bb11b88c5203ddd",
"assets/assets/lohu.png": "b7054f4241a6244e3bb11b88c5203ddd",
"assets/assets/nav.jpg": "2b3edb72780f1369d413c60b89e5cd0e",
"assets/assets/p1.jpg": "c44bfdb07bad1fcc6dd92f9620778812",
"assets/assets/pl2.jpg": "ede15f287f4213871b93ceaef9135b55",
"assets/assets/pl3.jpg": "502d7966db4d6a576b843ac9b2361b23",
"assets/assets/pl4.jpg": "f0cea5647be92d38a11ec26c296edd08",
"assets/assets/plg.png": "4d297b3af3a15f73e0234f8d84279eec",
"assets/assets/pnding.json": "5c155ef537e313d0558565f560df4724",
"assets/assets/saft.jpg": "ba5f70380d0473692729e9f77e739308",
"assets/assets/sbmenu.png": "64cf28e1e707b3a3793d1d3ab2102a47",
"assets/assets/sl1.jpg": "c3c5f33ddccef48e72c0a9e6ef24138c",
"assets/assets/sl2.webp": "924abb87e20be0b2e20174bbe8ed2568",
"assets/assets/sl3.jpeg": "237ec280411f99017bd7eaeaf2bd8027",
"assets/assets/sucessful.json": "77803a6057dd4762500fa8ba14782159",
"assets/FontManifest.json": "dc3d03800ccca4601324923c0b1d6d57",
"assets/fonts/MaterialIcons-Regular.otf": "19837a4181b4d2d07de85adb69a43824",
"assets/NOTICES": "919bbc6e5b5bd12b6fe84e9f4c191434",
"assets/packages/cupertino_icons/assets/CupertinoIcons.ttf": "33b7d9392238c04c131b6ce224e13711",
"assets/shaders/ink_sparkle.frag": "ecc85a2e95f5e9f53123dcaf8cb9b6ce",
"canvaskit/canvaskit.js": "728b2d477d9b8c14593d4f9b82b484f3",
"canvaskit/canvaskit.js.symbols": "bdcd3835edf8586b6d6edfce8749fb77",
"canvaskit/canvaskit.wasm": "7a3f4ae7d65fc1de6a6e7ddd3224bc93",
"canvaskit/chromium/canvaskit.js": "8191e843020c832c9cf8852a4b909d4c",
"canvaskit/chromium/canvaskit.js.symbols": "b61b5f4673c9698029fa0a746a9ad581",
"canvaskit/chromium/canvaskit.wasm": "f504de372e31c8031018a9ec0a9ef5f0",
"canvaskit/skwasm.js": "ea559890a088fe28b4ddf70e17e60052",
"canvaskit/skwasm.js.symbols": "e72c79950c8a8483d826a7f0560573a1",
"canvaskit/skwasm.wasm": "39dd80367a4e71582d234948adc521c0",
"favicon.png": "8fbccf622d02396c5a5bb2b030fa3112",
"flutter.js": "83d881c1dbb6d6bcd6b42e274605b69c",
"flutter_bootstrap.js": "8ee278e045a8ea730249eb06cc5afd8b",
"icons/Icon-192.png": "177bba9d0afaea2a37c94ae3615ea609",
"icons/Icon-512.png": "8fbccf622d02396c5a5bb2b030fa3112",
"icons/Icon-maskable-192.png": "8fbccf622d02396c5a5bb2b030fa3112",
"icons/Icon-maskable-512.png": "8fbccf622d02396c5a5bb2b030fa3112",
"index.html": "c92a1b4a23cdcba313fc2f46c00fa386",
"/": "c92a1b4a23cdcba313fc2f46c00fa386",
"main.dart.js": "ced9f792124a3b3501b15604b2793af2",
"manifest.json": "4add46471ff0464b9fb4dddb59c83e25",
"version.json": "b88d8c21c786a34490bfb4f5d569ab52"};
// The application shell files that are downloaded before a service worker can
// start.
const CORE = ["main.dart.js",
"index.html",
"flutter_bootstrap.js",
"assets/AssetManifest.bin.json",
"assets/FontManifest.json"];

// During install, the TEMP cache is populated with the application shell files.
self.addEventListener("install", (event) => {
  self.skipWaiting();
  return event.waitUntil(
    caches.open(TEMP).then((cache) => {
      return cache.addAll(
        CORE.map((value) => new Request(value, {'cache': 'reload'})));
    })
  );
});
// During activate, the cache is populated with the temp files downloaded in
// install. If this service worker is upgrading from one with a saved
// MANIFEST, then use this to retain unchanged resource files.
self.addEventListener("activate", function(event) {
  return event.waitUntil(async function() {
    try {
      var contentCache = await caches.open(CACHE_NAME);
      var tempCache = await caches.open(TEMP);
      var manifestCache = await caches.open(MANIFEST);
      var manifest = await manifestCache.match('manifest');
      // When there is no prior manifest, clear the entire cache.
      if (!manifest) {
        await caches.delete(CACHE_NAME);
        contentCache = await caches.open(CACHE_NAME);
        for (var request of await tempCache.keys()) {
          var response = await tempCache.match(request);
          await contentCache.put(request, response);
        }
        await caches.delete(TEMP);
        // Save the manifest to make future upgrades efficient.
        await manifestCache.put('manifest', new Response(JSON.stringify(RESOURCES)));
        // Claim client to enable caching on first launch
        self.clients.claim();
        return;
      }
      var oldManifest = await manifest.json();
      var origin = self.location.origin;
      for (var request of await contentCache.keys()) {
        var key = request.url.substring(origin.length + 1);
        if (key == "") {
          key = "/";
        }
        // If a resource from the old manifest is not in the new cache, or if
        // the MD5 sum has changed, delete it. Otherwise the resource is left
        // in the cache and can be reused by the new service worker.
        if (!RESOURCES[key] || RESOURCES[key] != oldManifest[key]) {
          await contentCache.delete(request);
        }
      }
      // Populate the cache with the app shell TEMP files, potentially overwriting
      // cache files preserved above.
      for (var request of await tempCache.keys()) {
        var response = await tempCache.match(request);
        await contentCache.put(request, response);
      }
      await caches.delete(TEMP);
      // Save the manifest to make future upgrades efficient.
      await manifestCache.put('manifest', new Response(JSON.stringify(RESOURCES)));
      // Claim client to enable caching on first launch
      self.clients.claim();
      return;
    } catch (err) {
      // On an unhandled exception the state of the cache cannot be guaranteed.
      console.error('Failed to upgrade service worker: ' + err);
      await caches.delete(CACHE_NAME);
      await caches.delete(TEMP);
      await caches.delete(MANIFEST);
    }
  }());
});
// The fetch handler redirects requests for RESOURCE files to the service
// worker cache.
self.addEventListener("fetch", (event) => {
  if (event.request.method !== 'GET') {
    return;
  }
  var origin = self.location.origin;
  var key = event.request.url.substring(origin.length + 1);
  // Redirect URLs to the index.html
  if (key.indexOf('?v=') != -1) {
    key = key.split('?v=')[0];
  }
  if (event.request.url == origin || event.request.url.startsWith(origin + '/#') || key == '') {
    key = '/';
  }
  // If the URL is not the RESOURCE list then return to signal that the
  // browser should take over.
  if (!RESOURCES[key]) {
    return;
  }
  // If the URL is the index.html, perform an online-first request.
  if (key == '/') {
    return onlineFirst(event);
  }
  event.respondWith(caches.open(CACHE_NAME)
    .then((cache) =>  {
      return cache.match(event.request).then((response) => {
        // Either respond with the cached resource, or perform a fetch and
        // lazily populate the cache only if the resource was successfully fetched.
        return response || fetch(event.request).then((response) => {
          if (response && Boolean(response.ok)) {
            cache.put(event.request, response.clone());
          }
          return response;
        });
      })
    })
  );
});
self.addEventListener('message', (event) => {
  // SkipWaiting can be used to immediately activate a waiting service worker.
  // This will also require a page refresh triggered by the main worker.
  if (event.data === 'skipWaiting') {
    self.skipWaiting();
    return;
  }
  if (event.data === 'downloadOffline') {
    downloadOffline();
    return;
  }
});
// Download offline will check the RESOURCES for all files not in the cache
// and populate them.
async function downloadOffline() {
  var resources = [];
  var contentCache = await caches.open(CACHE_NAME);
  var currentContent = {};
  for (var request of await contentCache.keys()) {
    var key = request.url.substring(origin.length + 1);
    if (key == "") {
      key = "/";
    }
    currentContent[key] = true;
  }
  for (var resourceKey of Object.keys(RESOURCES)) {
    if (!currentContent[resourceKey]) {
      resources.push(resourceKey);
    }
  }
  return contentCache.addAll(resources);
}
// Attempt to download the resource online before falling back to
// the offline cache.
function onlineFirst(event) {
  return event.respondWith(
    fetch(event.request).then((response) => {
      return caches.open(CACHE_NAME).then((cache) => {
        cache.put(event.request, response.clone());
        return response;
      });
    }).catch((error) => {
      return caches.open(CACHE_NAME).then((cache) => {
        return cache.match(event.request).then((response) => {
          if (response != null) {
            return response;
          }
          throw error;
        });
      });
    })
  );
}
